import org.uddi4j.client.UDDIProxy;
import org.uddi4j.datatype.Name;
import org.uddi4j.response.AuthToken;
import org.uddi4j.response.BusinessInfo;
import org.uddi4j.response.BusinessInfos;
import org.uddi4j.response.BusinessList;
import org.uddi4j.response.DispositionReport;
import org.uddi4j.response.ServiceInfo;
import org.uddi4j.response.ServiceInfos;
import org.uddi4j.response.ServiceList;
import org.uddi4j.transport.TransportFactory;
import java.security.Security;
import java.util.Vector;

public class UDDIDeleteService1 {

	public static void main(String[] args) throws Exception {

		System.setProperty("java.protocol.handler.pkgs", "com.sun.net.ssl.internal.www.protocol");      
		Security.addProvider(new com.sun.net.ssl.internal.ssl.Provider());

		System.setProperty(TransportFactory.PROPERTY_NAME, "org.uddi4j.transport.ApacheAxisTransport");

		UDDIProxy proxy = new UDDIProxy();
		proxy.setInquiryURL("http://uddi.microsoft.com/inquire");
		proxy.setPublishURL("https://uddi.microsoft.com/publish");

		Vector names = new Vector();
		names.add(new Name("Services Web & compagnie"));
		BusinessList bl = proxy.find_business(names, null, null, null, null, null, 0);

		BusinessInfos bis = bl.getBusinessInfos();
		if (bis.size() == 0) {
			System.out.println("no business(es) found");
			System.exit(0);
		}

		AuthToken at = proxy.get_authToken("user", "password");

		System.out.println(bis.size()+" business(es) found\n");
		Vector biv = bis.getBusinessInfoVector();
		for (int i = 0; i < biv.size(); i++) {
			BusinessInfo bi = (BusinessInfo)biv.elementAt(i);
			System.out.println(bi.getNameString());
			System.out.println(bi.getBusinessKey());
			System.out.println("\n");
			names = new Vector();
			names.add(new Name("Mon API de recherche UDDI"));
			ServiceList sl = proxy.find_service(bi.getBusinessKey(), names, null, null, null, 0);

			ServiceInfos sis = sl.getServiceInfos();
			if (sis.size() == 0) {
				System.out.println("no service(s) found");
			}
			else {
				System.out.println(sis.size()+" service(s) found\n");
				Vector siv = sis.getServiceInfoVector();
				for (int j = 0; j < siv.size(); j++) {
					ServiceInfo si = (ServiceInfo)siv.elementAt(j);
					System.out.println(si.getNameString());
					System.out.println(si.getServiceKey());
					DispositionReport dr = proxy.delete_service(at.getAuthInfoString(), si.getServiceKey());
					System.out.println("service deleted : "+dr.success());
					System.out.println("\n");
				}
			}
		}
		proxy.discard_authToken(at.getAuthInfo());
	}
}